in vec2 texCoord;
uniform sampler2D colorMap;
uniform float testvalue;


void main()
{
	float x_dest=-texCoord.x+0.5;//gl_Position.x/1920.0;
	float y_dest=-texCoord.y+0.5;//gl_Position.y/1080.0;
	float zoom=1.0*0.675;
	x_dest*=zoom;
	y_dest*=zoom;
	float x_src=0.0;
	float y_src=0.0;
	float distance=1.0*0.5; // *testvalue;
	// params: double distance

	float theta;
	float r;
	float s;
	float v[3];

	r=sqrt(x_dest*x_dest+y_dest*y_dest);
	theta=r/distance;
	if (theta==0.0)
		s=1.0/distance;
	else
		s=sin(theta)/r;

	v[1]=s*x_dest;
	v[0]=cos(theta);

	x_src=distance*atan2(v[1], v[0]);
	y_src=distance*atan(s*y_dest/sqrt(v[0]*v[0]+v[1]*v[1]));

	vec4 color=texture2D(colorMap,vec2(-x_src,y_src+0.5));

	gl_FragColor=color.rgba;
}
